<?php
/*#################################################################################
	AdLogger
	- An open-source tracking tool for preventing click fraud

	Copyright 2006 by Trevor Fitzgerald
	http://www.adlogger.org

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	If you find this script useful, please share it with others!

	Thank you!
*/#################################################################################

// Include the configuration files.
require ("../config_database.php");
require ("../config_settings.php");
require ("../config_admin.php");

// Make sure the person is logged in.
require ("./loginverify.php");

/*
 * Include the functions. Start the page timer, output the opening HTML,
 * and verify that we can actually connect to the database.
*/
require ("./functions.php");
	$start_time = micro_time(0);
	bodyHeader('blocked_visitor', $version_num);
	bodyNavigation('blocked_visitor');
	check_db_connection($adlogger_db_connect, $adlogger_db_select);

if (isset($_GET['visitor_ip']) && !empty($_GET['visitor_ip'])) {

	$visitor_ip = mysql_real_escape_string($_GET['visitor_ip']);

		if (!valid_ip($visitor_ip)) {
				echo '<div id="main-copy"><h1>Error!</h1><p>Invalid IP address.</p></div>';
				bodyFooter('error', $start_time);
				exit();
		}

} else {

	echo '<div id="main-copy">' .
			'<h1>Error!</h1>' .
			'<p>There was an error processing your request. The visitor IP was not specified.</p>' .
		'</div>';
	bodyFooter('error', $start_time);
	exit();

}

/*
 * Calculate how many times that IP address has been blocked.
 */
$sql = "SELECT COUNT(id) FROM " . $db_table_prefix . "blocklogs WHERE visitor_ip = '$visitor_ip'";
$result = mysql_query($sql);
	$row = mysql_fetch_array($result);
	$block_count_visitor = $row['COUNT(id)'];
		// If zero results, produce an error.
		if ($block_count_visitor == 0) {
			echo '<div id="main-copy"><h1>Error!</h1><p>Invalid entry. No data for that visitor IP.</p></div>';
			bodyFooter('error', $start_time);
			exit();
		}
?>

<div id="side-bar">
	<div>
		<p class="sideBarTitle">Blocking Info</p>
		<ul>
			<li><a href="#blocking_report">&rsaquo; Blocking Report</a></li>
			<li><a href="#blocking_history">&rsaquo; Blocking History</a></li>
		</ul>
	</div>
</div>

<div id="main-copy">

	<h1 id="blocking_report">Blocking Report</h1>
	<br />
	
	<div align="center">
		<table summary="overview" width="65%" id="greytable">
			<tbody id="greytbody">
				<tr>
					<td width="35%"><strong>Visitor IP:</strong></td>
					<td width="65%"><?php echo $visitor_ip; ?></td>
				</tr>
				<tr class="odd">
					<td><strong>Visitor Hostname:</strong></td>
					<td><?php echo (gethostbyaddr($visitor_ip)); ?></td>
				</tr>
				<tr class="odd">
					<td><strong>Number of blocked ads:</strong></td>
					<td><?php echo $block_count_visitor; ?></td>
				</tr>
				<tr class="odd">
					<td><strong>More info on this visitor:</strong></td>
					<td><a href="<?php echo $ip_info_url . $visitor_ip; ?>">More Info</a></td>
				</tr>
			</tbody>
		</table>
	</div>

	<h1 id="blocking_history">Blocking History</h1>
	<br />

	<div align="center">
<?php
/*
 * Start pagination code
 */
	$sql = "
			SELECT COUNT(id)
				FROM " . $db_table_prefix . "blocklogs
					WHERE visitor_ip = '$visitor_ip'
						";

	$result = mysql_query($sql);
		$row = mysql_fetch_array($result);
		$numrows = $row['COUNT(id)'];

	if (isset($_GET['pageno']) && !empty($_GET['pageno'])) {
	   $pageno = $_GET['pageno'];
	} else {
	   $pageno = 1;
	}

	if (isset($_GET['sortnum']) && !empty($_GET['sortnum'])) {
		$rows_per_page = $_GET['sortnum'];
	} else {
		$rows_per_page = 10;
	}

	$lastpage = ceil($numrows/$rows_per_page);
	if ($lastpage == 0) $lastpage = 1;

	$pageno = (int)$pageno;

	$limit = 'LIMIT ' .($pageno - 1) * $rows_per_page .',' .$rows_per_page;

	if ($pageno <= 1) {
		echo " FIRST PREV ";
	} else {
		echo " <a href='{$_SERVER['PHP_SELF']}?visitor_ip=$visitor_ip&amp;pageno=1&amp;sortnum=$rows_per_page#blocking_history'>FIRST</a> ";
		$prevpage = $pageno - 1;
		echo " <a href='{$_SERVER['PHP_SELF']}?visitor_ip=$visitor_ip&amp;pageno=$prevpage&amp;sortnum=$rows_per_page#blocking_history'>PREV</a> ";
	}

	echo " ( Page $pageno of $lastpage ) ";

	if ($pageno >= $lastpage) {
		echo " NEXT LAST ";
	} else {
		$nextpage = $pageno + 1;
		echo " <a href='{$_SERVER['PHP_SELF']}?visitor_ip=$visitor_ip&amp;pageno=$nextpage&amp;sortnum=$rows_per_page#blocking_history'>NEXT</a> ";
		echo " <a href='{$_SERVER['PHP_SELF']}?visitor_ip=$visitor_ip&amp;pageno=$lastpage&amp;sortnum=$rows_per_page#blocking_history'>LAST</a> ";
	}

?>
	</div>
	<br />

	<?php if ($numrows > 0) { ?>

			<table summary="blocking_history" width="100%" id="greytable">

				<thead id="greythead">
					<tr>
						<th scope="col">Date</th>
						<th scope="col">Time</th>
						<th scope="col">Reason for Blocking</th>
						<th scope="col">Blocked Ads URL</th>
					</tr>
				</thead>

				<tbody id="greytbody">

				<?php
					/*
					Perform the query on the database to grab the rows.
					*/
					$sql = "
							SELECT *
								FROM " . $db_table_prefix . "blocklogs
									WHERE visitor_ip = '$visitor_ip'
										ORDER BY id desc
											$limit
												";

					$result = mysql_query($sql) or die(mysql_error());
					/*
					Start the loop to display them.  In this loop, the script creates
					a new table row for each entry it finds from the database.
					*/
					while($row = mysql_fetch_array($result)) {
						$id = $row['id'];
						$timestamp = $row['timestamp'];
							// Convert that UNIX timestamp to something a little more useable
							$date = date('M j, Y', $timestamp);
							$time = date('g:i:s a', $timestamp);
						$visitor_ip = $row['visitor_ip'];
						$reason = $row['reason'];
						$blocked_url = urldecode($row['blocked_url']);
						
							/*
							 * Translate into English why ads were disabled
							 */
							if ($reason == 1) {
								$reason_text = "Ads disabled site-wide";
							} elseif ($reason == 2) {
								$reason_text = "On IP Ban List";
							} elseif ($reason == 3) {
								$reason_text = "Too many reported clicks from this IP address";
							} else {
								$reason_text = $reason;
							}
					?>
						<tr class="odd">
							<td><?php echo $date; ?></td>
							<td><?php echo $time; ?></td>
							<td><?php echo $reason_text; ?></td>
							<td><?php echo shortenURL($blocked_url); ?></td>
						</tr>
					<?php } /* End the loop. */ ?>

				</tbody>

			</table>
	<?php } ?>

</div>

<?php bodyFooter('blocked_visitor', $start_time); ?>